/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx.ft4222;

import android.util.Log;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.ft4222.FT_4222_Device;
import com.ftdi.j2xx.ft4222.SPI_MasterCfg;
import com.ftdi.j2xx.ft4222.chiptop_mgr;
import com.ftdi.j2xx.interfaces.SpiMaster;
import junit.framework.Assert;

public class FT_4222_Spi_Master
implements SpiMaster {
    private FT_4222_Device mFT4222Device;
    private FT_Device mFTDevice;
    private static final String TAG = "FTDI_Device::";
    private byte[] mPackWrBuf = new byte[16384];
    private byte[] mPackRdBuf = new byte[16384];

    public FT_4222_Spi_Master(FT_4222_Device pDevice) {
        this.mFT4222Device = pDevice;
        this.mFTDevice = pDevice.mFtDev;
    }

    @Override
    public int init(int ioLine, int clock, int cpol, int cpha, byte ssoMap) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        int venderSSOMap = 0;
        SPI_MasterCfg config = this.mFT4222Device.mSpiMasterCfg;
        config.ioLine = ioLine;
        config.clock = clock;
        config.cpol = cpol;
        config.cpha = cpha;
        config.ssoMap = ssoMap;
        if (config.ioLine != 1 && config.ioLine != 2 && config.ioLine != 4) {
            return 6;
        }
        this.mFT4222Device.cleanRxData();
        switch (chipStatus.chip_mode) {
            case 0: {
                venderSSOMap = 1;
                break;
            }
            case 1: {
                venderSSOMap = 7;
                break;
            }
            case 2: {
                venderSSOMap = 15;
                break;
            }
            case 3: {
                venderSSOMap = 1;
            }
        }
        if ((venderSSOMap & config.ssoMap) == 0) {
            return 6;
        }
        config.ssoMap = (byte)(config.ssoMap & venderSSOMap);
        int venderSS = 0;
        int verderFun = 3;
        if (this.mFTDevice.VendorCmdSet(33, 0x42 | config.ioLine << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x44 | config.clock << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x45 | config.cpol << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x46 | config.cpha << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x43 | venderSS << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x48 | config.ssoMap << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 5 | verderFun << 8) < 0) {
            return 4;
        }
        chipStatus.function = (byte)3;
        return 0;
    }

    @Override
    public int setLines(int spiMode) {
        int verderRestart = 1;
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        if (chipStatus.function != 3) {
            return 1003;
        }
        if (spiMode == 0) {
            return 17;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x42 | spiMode << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x4A | verderRestart << 8) < 0) {
            return 4;
        }
        SPI_MasterCfg spiCfg = this.mFT4222Device.mSpiMasterCfg;
        spiCfg.ioLine = spiMode;
        return 0;
    }

    @Override
    public int singleWrite(byte[] writeBuffer, int sizeToTransfer, int[] sizeTransferred, boolean isEndTransaction) {
        byte[] readBuffer = new byte[writeBuffer.length];
        return this.singleReadWrite(readBuffer, writeBuffer, sizeToTransfer, sizeTransferred, isEndTransaction);
    }

    @Override
    public int singleRead(byte[] readBuffer, int sizeToTransfer, int[] sizeOfRead, boolean isEndTransaction) {
        byte[] writeBuffer = new byte[readBuffer.length];
        return this.singleReadWrite(readBuffer, writeBuffer, sizeToTransfer, sizeOfRead, isEndTransaction);
    }

    @Override
    public int singleReadWrite(byte[] readBuffer, byte[] writeBuffer, int sizeToTransfer, int[] sizeTransferred, boolean isEndTransaction) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        SPI_MasterCfg spiCfg = this.mFT4222Device.mSpiMasterCfg;
        if (writeBuffer == null || readBuffer == null || sizeTransferred == null) {
            return 1009;
        }
        sizeTransferred[0] = 0;
        if (chipStatus.function != 3 || spiCfg.ioLine != 1) {
            return 1005;
        }
        if (sizeToTransfer == 0) {
            return 6;
        }
        if (sizeToTransfer > writeBuffer.length || sizeToTransfer > readBuffer.length) {
            Assert.assertTrue((String)"sizeToTransfer > writeBuffer.length || sizeToTransfer > readBuffer.length", (boolean)false);
        }
        if (writeBuffer.length != readBuffer.length || writeBuffer.length == 0) {
            Assert.assertTrue((String)"writeBuffer.length != readBuffer.length || writeBuffer.length == 0", (boolean)false);
        }
        sizeTransferred[0] = this.sendReadWriteBuffer(this.mFTDevice, writeBuffer, readBuffer, sizeToTransfer);
        if (isEndTransaction) {
            this.mFTDevice.write(null, 0);
        }
        if (sizeTransferred[0] == -1) {
            return 10;
        }
        if (sizeTransferred[0] == -2) {
            return 1011;
        }
        return 0;
    }

    @Override
    public int multiReadWrite(byte[] readBuffer, byte[] writeBuffer, int singleWriteBytes, int multiWriteBytes, int multiReadBytes, int[] sizeOfRead) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        SPI_MasterCfg spiCfg = this.mFT4222Device.mSpiMasterCfg;
        if (multiReadBytes > 0 && readBuffer == null) {
            return 1009;
        }
        if (singleWriteBytes + multiWriteBytes > 0 && writeBuffer == null) {
            return 1009;
        }
        if (multiReadBytes > 0 && sizeOfRead == null) {
            return 1009;
        }
        if (chipStatus.function != 3 || spiCfg.ioLine == 1) {
            return 1006;
        }
        if (singleWriteBytes > 15) {
            Log.e((String)TAG, (String)"The maxium single write bytes are 15 bytes");
            return 6;
        }
        int sendDataSize = 5 + singleWriteBytes + multiWriteBytes;
        byte[] sendData = new byte[sendDataSize];
        sendData[0] = (byte)(0x80 | singleWriteBytes & 0xF);
        sendData[1] = (byte)((multiWriteBytes & 0xFF00) >> 8);
        sendData[2] = (byte)(multiWriteBytes & 0xFF);
        sendData[3] = (byte)((multiReadBytes & 0xFF00) >> 8);
        sendData[4] = (byte)(multiReadBytes & 0xFF);
        for (int i = 0; i < singleWriteBytes + multiWriteBytes; ++i) {
            sendData[i + 5] = writeBuffer[i];
        }
        sizeOfRead[0] = this.setMultiReadWritePackage(this.mFTDevice, sendData, readBuffer, multiReadBytes);
        return 0;
    }

    @Override
    public int reset() {
        int verderReset = 0;
        if (this.mFTDevice.VendorCmdSet(33, 0x4A | verderReset << 8) < 0) {
            return 4;
        }
        return 0;
    }

    public int setDrivingStrength(int clkStrength, int ioStrength, int ssoStregth) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        if (chipStatus.function != 3 && chipStatus.function != 4) {
            return 1003;
        }
        int actual_strength = clkStrength << 4;
        actual_strength |= ioStrength << 2;
        int verderFun = chipStatus.function == 3 ? 3 : 4;
        if (this.mFTDevice.VendorCmdSet(33, 0xA0 | (actual_strength |= ssoStregth) << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 5 | verderFun << 8) < 0) {
            return 4;
        }
        return 0;
    }

    private int setMultiReadWritePackage(FT_Device ftSPIDevice, byte[] wr_buffer, byte[] rd_buffer, int multiReadBytes) {
        int ret = 0;
        boolean sleepCnt = false;
        int maxWaitTime = 30000;
        int bytesRead = 0;
        if (ftSPIDevice == null || !ftSPIDevice.isOpen()) {
            return -1;
        }
        ret = this.sendMultiWriteBuffer(ftSPIDevice, wr_buffer);
        bytesRead = this.sendMultiReadBuffer(ftSPIDevice, rd_buffer, multiReadBytes);
        return bytesRead;
    }

    private int sendMultiWriteBuffer(FT_Device ftSPIDevice, byte[] wr_buffer) {
        int packCount = wr_buffer.length / this.mPackWrBuf.length;
        int restCount = wr_buffer.length % this.mPackWrBuf.length;
        int writeIdx = 0;
        int valRet = 0;
        for (int i = 0; i < packCount; ++i) {
            for (int j = 0; j < this.mPackWrBuf.length; ++j) {
                this.mPackWrBuf[j] = wr_buffer[writeIdx];
                ++writeIdx;
            }
            valRet = ftSPIDevice.write(this.mPackWrBuf, this.mPackWrBuf.length);
            if (this.mPackWrBuf.length != valRet) {
                Log.e((String)TAG, (String)"sendMultiWriteBuffer write error!!!");
                return -1;
            }
            if (valRet > 0) continue;
            return valRet;
        }
        if (restCount > 0) {
            for (int j = 0; j < restCount; ++j) {
                this.mPackWrBuf[j] = wr_buffer[writeIdx];
                ++writeIdx;
            }
            valRet = ftSPIDevice.write(this.mPackWrBuf, restCount);
            if (restCount != valRet) {
                Log.e((String)TAG, (String)"sendMultiWriteBuffer write error!!!");
                return -1;
            }
            if (valRet <= 0) {
                return valRet;
            }
        }
        return writeIdx;
    }

    private int sendMultiReadBuffer(FT_Device ftSPIDevice, byte[] rd_buffer, int multiReadBytes) {
        boolean ret = false;
        int bytesRead = 0;
        bytesRead = ftSPIDevice.read(rd_buffer, multiReadBytes);
        return bytesRead;
    }

    private int sendReadWriteBuffer(FT_Device ftDevice, byte[] wr_buffer, byte[] rd_buffer, int sizeToTransfer) {
        int packCount = sizeToTransfer / this.mPackWrBuf.length;
        int restCount = sizeToTransfer % this.mPackWrBuf.length;
        int readIdx = 0;
        int writeIdx = 0;
        int valRet = 0;
        for (int i = 0; i < packCount; ++i) {
            int j;
            for (j = 0; j < this.mPackWrBuf.length; ++j) {
                this.mPackWrBuf[j] = wr_buffer[writeIdx];
                ++writeIdx;
            }
            valRet = this.setReadWritePackage(ftDevice, this.mPackWrBuf, this.mPackRdBuf, this.mPackWrBuf.length);
            if (valRet <= 0) {
                return valRet;
            }
            for (j = 0; j < this.mPackRdBuf.length; ++j) {
                rd_buffer[readIdx] = this.mPackRdBuf[j];
                ++readIdx;
            }
        }
        if (restCount > 0) {
            int j;
            for (j = 0; j < restCount; ++j) {
                this.mPackWrBuf[j] = wr_buffer[writeIdx];
                ++writeIdx;
            }
            valRet = this.setReadWritePackage(ftDevice, this.mPackWrBuf, this.mPackRdBuf, restCount);
            if (valRet <= 0) {
                return valRet;
            }
            for (j = 0; j < restCount; ++j) {
                rd_buffer[readIdx] = this.mPackRdBuf[j];
                ++readIdx;
            }
        }
        return readIdx;
    }

    private int setReadWritePackage(FT_Device ftSPIDevice, byte[] wr_buffer, byte[] rd_buffer, int wr_rd_size) {
        int ret = 0;
        int sleepCnt = 0;
        int maxWaitTime = 30000;
        int bytesRead = 0;
        if (ftSPIDevice == null || !ftSPIDevice.isOpen()) {
            return -1;
        }
        ret = ftSPIDevice.write(wr_buffer, wr_rd_size);
        if (wr_rd_size != ret) {
            Log.e((String)TAG, (String)"setReadWritePackage write error!!!");
            return -1;
        }
        while (bytesRead < wr_rd_size && sleepCnt < maxWaitTime) {
            ret = ftSPIDevice.getQueueStatus();
            if (ret > 0) {
                sleepCnt = 0;
                ret = ftSPIDevice.read(wr_buffer, ret);
                for (int i = 0; i < ret; ++i) {
                    if (bytesRead + i >= wr_rd_size) continue;
                    rd_buffer[bytesRead + i] = wr_buffer[i];
                }
                bytesRead += ret;
            }
            Thread.yield();
        }
        if (wr_rd_size != bytesRead || sleepCnt > maxWaitTime) {
            Log.e((String)TAG, (String)"SingleReadWritePackage timeout!!!!");
            return -1;
        }
        return bytesRead;
    }
}

